function boolToString(b)
	return b and "true" or "false";
end;

function strleft(str, lenght)
	return string.sub(str, 1, lenght)
end

function strright(str, lenght)
	return string.sub(str, -(tonumber(lenght)))
end

function strmiddle(str, start, final)
	return string.sub(str, start, final)
end

function string.starts(String,Start)
   return string.sub(String,1,string.len(Start))==Start
end

function string.ends(String,End)
   return End=='' or string.sub(String,-string.len(End))==End
end

function trimStr(s)
   return (s:gsub("^%s*(.-)%s*$", "%1"))
end

--gsub ignore case
function gisub(s, pat, repl, n)
    pat = string.gsub(pat, '(%a)', 
               function (v) return '['..string.upper(v)..string.lower(v)..']' end)
    if n then
        return string.gsub(s, pat, repl, n)
    else
        return string.gsub(s, pat, repl)
    end
end


function to_string( tbl )
    if  "nil"       == type( tbl ) then
        return tostring(nil)
    elseif  "table" == type( tbl ) then
        return table_print(tbl)
    elseif  "string" == type( tbl ) then
        return tbl
    else
        return tostring(tbl)
    end
end

function table_print (tt, indent, done)
  done = done or {}
  indent = indent or 0
  if type(tt) == "table" then
    local sb = {}
    for key, value in pairs (tt) do
      table.insert(sb, string.rep (" ", indent)) -- indent it
      if type (value) == "table" and not done [value] then
        done [value] = true
        table.insert(sb, to_string(key) .. " = {\n");
        table.insert(sb, table_print (value, indent + 2, done))
        table.insert(sb, string.rep (" ", indent)) -- indent it
        table.insert(sb, "}\n");
      elseif "number" == type(key) then
        table.insert(sb, string.format("\"%s\",", tostring(value)))
      else
        table.insert(sb, string.format(
            "%s = \"%s\"\n", tostring (key), tostring(value)))
       end
    end
    return table.concat(sb)
  else
    return tt .. "\n"
  end
end

function strArrayToString(a)
	local s = "";
	for i = 1, #a do
		if type(a[i]) == "string" then
			s = s..a[i]..",";
		elseif type(a[i]) == "boolean" then
			s = s..boolToString(a[i])..","
		else
			s = s.."UNKNOWN TYPE ("..type(a[i]).."),";
		end;
	end
	return s;
end


--Because GetCurrentGame returns lowercase, but StepsType wants uppercase.
function firstToUpper(str)
    return (str:gsub("^%l", string.upper))
end
